<?php

namespace App\Test\Controller;

use App\Entity\ApplicationRequirement;
use App\Repository\ApplicationRequirementRepository;
use Symfony\Bundle\FrameworkBundle\KernelBrowser;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

class ApplicationRequirementControllerTest extends WebTestCase
{
    private KernelBrowser $client;
    private ApplicationRequirementRepository $repository;
    private string $path = '/application/requirement/';

    protected function setUp(): void
    {
        $this->client = static::createClient();
        $this->repository = (static::getContainer()->get('doctrine'))->getRepository(ApplicationRequirement::class);

        foreach ($this->repository->findAll() as $object) {
            $this->repository->remove($object, true);
        }
    }

    public function testIndex(): void
    {
        $crawler = $this->client->request('GET', $this->path);

        self::assertResponseStatusCodeSame(200);
        self::assertPageTitleContains('ApplicationRequirement index');

        // Use the $crawler to perform additional assertions e.g.
        // self::assertSame('Some text on the page', $crawler->filter('.p')->first());
    }

    public function testNew(): void
    {
        $originalNumObjectsInRepository = count($this->repository->findAll());

        $this->markTestIncomplete();
        $this->client->request('GET', sprintf('%snew', $this->path));

        self::assertResponseStatusCodeSame(200);

        $this->client->submitForm('Save', [
            'application_requirement[cle]' => 'Testing',
            'application_requirement[userValue]' => 'Testing',
            'application_requirement[application]' => 'Testing',
        ]);

        self::assertResponseRedirects('/application/requirement/');

        self::assertSame($originalNumObjectsInRepository + 1, count($this->repository->findAll()));
    }

    public function testShow(): void
    {
        $this->markTestIncomplete();
        $fixture = new ApplicationRequirement();
        $fixture->setCle('My Title');
        $fixture->setUserValue('My Title');
        $fixture->setApplication('My Title');

        $this->repository->add($fixture, true);

        $this->client->request('GET', sprintf('%s%s', $this->path, $fixture->getId()));

        self::assertResponseStatusCodeSame(200);
        self::assertPageTitleContains('ApplicationRequirement');

        // Use assertions to check that the properties are properly displayed.
    }

    public function testEdit(): void
    {
        $this->markTestIncomplete();
        $fixture = new ApplicationRequirement();
        $fixture->setCle('My Title');
        $fixture->setUserValue('My Title');
        $fixture->setApplication('My Title');

        $this->repository->add($fixture, true);

        $this->client->request('GET', sprintf('%s%s/edit', $this->path, $fixture->getId()));

        $this->client->submitForm('Update', [
            'application_requirement[cle]' => 'Something New',
            'application_requirement[userValue]' => 'Something New',
            'application_requirement[application]' => 'Something New',
        ]);

        self::assertResponseRedirects('/application/requirement/');

        $fixture = $this->repository->findAll();

        self::assertSame('Something New', $fixture[0]->getCle());
        self::assertSame('Something New', $fixture[0]->getUserValue());
        self::assertSame('Something New', $fixture[0]->getApplication());
    }

    public function testRemove(): void
    {
        $this->markTestIncomplete();

        $originalNumObjectsInRepository = count($this->repository->findAll());

        $fixture = new ApplicationRequirement();
        $fixture->setCle('My Title');
        $fixture->setUserValue('My Title');
        $fixture->setApplication('My Title');

        $this->repository->add($fixture, true);

        self::assertSame($originalNumObjectsInRepository + 1, count($this->repository->findAll()));

        $this->client->request('GET', sprintf('%s%s', $this->path, $fixture->getId()));
        $this->client->submitForm('Delete');

        self::assertSame($originalNumObjectsInRepository, count($this->repository->findAll()));
        self::assertResponseRedirects('/application/requirement/');
    }
}
